% clear all
% load stat800.mat
% load mem800.mat
% load plot800.mat

sol_size = sum(P==true,'all');
close all
fig1=figure(1); clf; set(fig1,'Position',[2 2 1200 800]);
hold on
grid on
set(gca,'FontSize',30)
plot(round(Lrat(1:10)*sol_size),'LineWidth',5,'Color','blue')
plot(round(Xrat(1:10)*sol_size),'LineWidth',5,'Color','red')
leg1 = legend('Cross Entropy','Reflected Cross Entropy','FontSize',40,'Location','northwest');
xlabel('Top 10 Attacks, Sorted by the Corresponding Loss','FontSize',40);
ylabel('Number of Optimal Attacks','FontSize',40);
topdf(fig1,'k=10.pdf');


close all
fig1=figure(1); clf; set(fig1,'Position',[2 2 1200 800]);
hold on
grid on
set(gca,'FontSize',30)
plot(round(Lrat(1:100)*sol_size),'LineWidth',5,'Color','blue')
plot(round(Xrat(1:100)*sol_size),'LineWidth',5,'Color','red')
leg1 = legend('Cross Entropy','Reflected Cross Entropy','FontSize',40,'Location','northwest');
xlabel('Top 100 Attacks, Sorted by the Corresponding Loss','FontSize',40);
ylabel('Number of Optimal Attacks','FontSize',40);
topdf(fig1,'k=100.pdf');

close all
fig1=figure(1); clf; set(fig1,'Position',[2 2 1200 800]);
hold on
grid on
set(gca,'FontSize',30)
plot(round(Lrat(1:1000)*sol_size),'LineWidth',5,'Color','blue')
plot(round(Xrat(1:1000)*sol_size),'LineWidth',5,'Color','red')
leg1 = legend('Cross Entropy','Reflected Cross Entropy','FontSize',40,'Location','northwest');
xlabel('Top 1000 Attacks, Sorted by the Corresponding Loss','FontSize',40);
ylabel('Number of Optimal Attacks','FontSize',40);
topdf(fig1,'k=1000.pdf');

 
close all
fig1=figure(1); clf; set(fig1,'Position',[2 2 1200 800]);
hold on
grid on
set(gca,'FontSize',30)
plot(round(Lrat(1:10000)*sol_size),'LineWidth',5,'Color','blue')
plot(round(Xrat(1:10000)*sol_size),'LineWidth',5,'Color','red')
leg1 = legend('Cross Entropy','Reflected Cross Entropy','FontSize',40,'Location','northwest');
xlabel('Top 10000 Attacks, Sorted by the Corresponding Loss','FontSize',40);
ylabel('Number of Optimal Attacks','FontSize',40);
topdf(fig1,'k=10000.pdf');
